% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_total_clearance.R
\name{calc_total_clearance}
\alias{calc_total_clearance}
\title{Calculate the total clearance.}
\usage{
calc_total_clearance(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  species = "Human",
  suppress.messages = F,
  default.to.human = F,
  well.stirred.correction = T,
  restrictive.clearance = T,
  adjusted.Funbound.plasma = T,
  ...
)
}
\arguments{
\item{chem.cas}{Either the chemical name, CAS number, or the parameters must
be specified.}

\item{chem.name}{Either the chemical name, CAS number, or the parameters
must be specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (https://comptox.epa.gov/dashboard)
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_steadystate
function, overrides chem.name and chem.cas.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{default.to.human}{Substitutes missing animal values with human values
if true.}

\item{well.stirred.correction}{Uses correction in calculation of hepatic
clearance for well-stirred model if TRUE.  This assumes clearance relative
to amount unbound in whole blood instead of plasma, but converted to use
with plasma concentration.}

\item{restrictive.clearance}{Protein binding is not taken into account (set
to 1) in liver clearance if FALSE.}

\item{adjusted.Funbound.plasma}{Uses adjusted Funbound.plasma when set to
TRUE.}

\item{...}{Additional parameters passed to parameterize_steadystate if
parameters is NULL.}
}
\value{
\item{Total Clearance}{Units of L/h/kg BW.}
}
\description{
This function calculates the total clearance rate for a one compartment model
where clearance is entirely due to metablism by the liver and glomerular
filtration in the kidneys, identical to clearance of three compartment
steady state model.
}
\examples{

calc_total_clearance(chem.name="Ibuprofen") 


}
\author{
John Wambaugh
}
\keyword{1compartment}
\keyword{Parameter}
