% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock-api.R
\name{buildMockURL}
\alias{buildMockURL}
\title{Convert a mock "URL" to a file path}
\usage{
buildMockURL(req, method = "GET")
}
\arguments{
\item{req}{A \code{request} object, or a character "URL" to convert}

\item{method}{character HTTP method. If \code{req} is a 'request' object,
its request method will override this argument}
}
\value{
A file path and name, with .json extension. The file may or may not
exist: existence is not a concern of this function.
}
\description{
Because HTTP allows "directories" to be resources themselves but the local
file system does not, this function disambiguates those cases. Use
HTTP-looking mock URLs in your fixtures, and this function lets you have both
"api/" and "api/object1/" exist as files.
}
\details{
This function also handles query parameters, as described in
\url{with_mock_API}.

This function is exported so that other packages can construct similar mock
behaviors or override specific requests at a higher level than
\code{with_mock_API} mocks.
}
