% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{Chr}
\alias{Chr}
\title{Find chromosome for SNP ids, gene name or band}
\usage{
Chr(ids, dir = NULL, snps.only = FALSE)
}
\arguments{
\item{ids}{character, a vector of rs-ids or chip-ids representing SNPs in the current ChipInfo
annotation, or gene ids, or karyotype bands. Can also be a SnpMatrix object.}

\item{dir}{character, only relevant when gene or band ids are entered, in this case 'dir' is the location
to download gene and cytoband information; if left as NULL, depending on the value of 
getOption("save.annot.in.current"), the annotation will either be saved in the working directory to 
speed-up subsequent lookups, or deleted after use.}

\item{snps.only}{logical, if TRUE, only search SNP ids, ignore the possibility of genes/cytobands.}
}
\value{
A character vector of Chromosomes for each ids, with NA values where no result was found.
}
\description{
Allows retrieval of the chromosome associated with a SNP-id, HGNC gene label, karyotype band,
or vector of such ids. For SNPs the ids can be either chip ids, or rs-ids, but must be contained
 in the current annotation. Default behaviour is to assume 'id' are SNP ids, but if none are
 found in the SNP annotation, the id's will be passed to functions Pos.gene() and Pos.band() to
 see whether a result is found. This latter step will only happen if no SNP ids are retreived in
 the first instance, and if snps.only=TRUE, then genes and bands will not be searched and NA's 
 returned. If you are repeatedly searching for chromosomes for genes/bands, using the dedicated 
 Pos.gene and Pos.band functions would be slightly faster than relying on the fallback behaviour
 of the Chr() function.  See documentation for these functions for more information. The build
 used will be that in the current ChipInfo object.
}
\examples{
\donttest{
setwd(tempdir())
Chr(c("rs689","rs9467354","rs61733845"))
Chr("CTLA4")
Chr("13q21.31")
Chr(c("CTLA4","PTPN22"),snps.only=TRUE) # fails as these are genes
Chr(c("rs689","PTPN22","13q21.31")) # mixed input, will default to SNPs, as at least 1 was found
}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\seealso{
\code{\link{Pos}}
}

