% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{escape_contents}
\alias{escape_contents}
\alias{escape_contents<-}
\alias{set_escape_contents}
\alias{escape_contents.huxtable}
\alias{escape_contents<-.huxtable}
\title{Get or Set Whether to Escape Cell Contents}
\usage{
escape_contents(ht)
escape_contents(ht) <- value
set_escape_contents(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A logical vector or matrix. If \code{TRUE}, cell contents will be HTML or LaTex escaped. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{escape_contents}, the \code{escape_contents} attribute.
For \code{set_escape_contents}, the \code{ht} object.
}
\description{
Functions to get or set the whether to escape cell contents property of huxtable table cells.
}
\examples{
ht <- huxtable(Exponent = 2:4, Example = paste0('$x^', 2:4, '$'))
escape_contents(ht)[,2] <- FALSE

}
