% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{number_format}
\alias{number_format}
\alias{number_format<-}
\alias{set_number_format}
\alias{number_format.huxtable}
\alias{number_format<-.huxtable}
\title{Get or Set Number Format}
\usage{
number_format(ht)
number_format(ht) <- value
set_number_format(ht, row, col, value)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A vector or list which may be character, numeric or function. See below. Set to \code{NA} to reset to the default.}

\item{row}{A row specifier.}

\item{col}{A column specifier.}
}
\value{
For \code{number_format}, the \code{number_format} attribute.
For \code{set_number_format}, the \code{ht} object.
}
\description{
Functions to get or set the number format property of huxtable table cells.
}
\details{
If \code{value} is numeric, numbers will be rounded to that many decimal places.  If \code{value} is
character, it will be taken as an argument to \code{\link{sprintf}}. If \code{value} is a
function it will be applied to the cell contents.
Number format is applied to any cells that look like numbers (as judged by \code{\link{as.numeric}}), not just to numeric cells. This allows you to do e.g. \code{ht <- huxtable(a = c('Salary', 35000, 32000, 40000))} and still format numbers correctly.
To set number_format to a function, enclose the function in \code{list}.
See the examples.
}
\examples{
ht <- huxtable(a = 10^(3:6) + (5 * 10^(-2:-5)), b = 10^(3:6) + (5* 10^(-2:-5)))
number_format(ht)[1,] <- 2
number_format(ht)[2,] <- '\%5.2f'
number_format(ht)[3,] <- list(function(x) prettyNum(x, big.mark = ','))
number_format(ht)[4,] <- list(function(x) if(x>0) '+' else '-')
ht
print_screen(ht)
}
\seealso{
Other formatting functions: \code{\link{background_color}},
  \code{\link{bold}}, \code{\link{font_size}},
  \code{\link{font}}, \code{\link{na_string}},
  \code{\link{text_color}}
}
