% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huxtable.R
\name{mutate_.huxtable}
\alias{mutate_.huxtable}
\alias{mutate}
\title{Dplyr verbs for huxtable}
\usage{
\method{mutate_}{huxtable}(.data, ..., .dots)
}
\arguments{
\item{.data}{A huxtable.}

\item{..., .dots}{Arguments passed to \code{\link[dplyr]{mutate}}.}
}
\description{
Huxtable can be used with dplyr verbs \code{\link[dplyr]{select}}, \code{\link[dplyr]{rename}},
\code{\link[dplyr]{slice}}, \code{\link[dplyr]{arrange}}, \code{\link[dplyr]{mutate}} and
\code{\link[dplyr]{transmute}}. These will return huxtables. Other verbs like \code{\link[dplyr]{summarize}}
will simply return data frames as normal.
}
\details{
If \code{mutate} creates new columns, and the argument \code{copy_cell_props} is missing or \code{TRUE}, then cell
and column properties will be copied from existing columns to their left, if there are any. Otherwise, they will be the
standard defaults. Row and table properties, and properties of cells in existing columns, remain unchanged.
}
\examples{
ht <- hux(a = 1:5, b = 1:5, c = 1:5, d = 1:5)
bold(ht)[c(1, 3), ] <- TRUE
bold(ht)[, 1] <- TRUE
ht2 <- dplyr::select(ht, b:c)
ht2
bold(ht2)
ht3 <- dplyr::mutate(ht, x = a + b)
ht3
bold(ht3)
ht4 <- dplyr::mutate(ht, x = a + b, copy_cell_props = FALSE)
bold(ht4)
}
