% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/huxtable.R
\name{[.huxtable}
\alias{[.huxtable}
\alias{[<-.huxtable}
\alias{$<-.huxtable}
\alias{[[<-.huxtable}
\title{Subset a huxtable}
\usage{
\method{[}{huxtable}(x, i, j, drop = FALSE)

\method{[}{huxtable}(x, i, j) <- value

\method{$}{huxtable}(x, name) <- value

\method{[[}{huxtable}(x, i, j) <- value
}
\arguments{
\item{x}{A huxtable.}

\item{i}{Rows to select.}

\item{j, name}{Columns to select.}

\item{drop}{Not used.}

\item{value}{A matrix, data frame, huxtable or similar object.}
}
\value{
A huxtable.
}
\description{
Subset a huxtable
}
\details{
\code{[} always returns a new huxtable object, while \code{$} and \code{[[} simply
return a vector of data.
For the replacement function \code{[<-}, if \code{value} is a huxtable, then its cell properties will be
copied into \code{x}. In addition, if \code{value} fills up an entire column, then column properties
will be copied into the replaced columns of \code{x}, and if it fills up an entire row, then
row properties will be copied into the replaced rows of \code{x}.
Replacement functions \code{$<-} and \code{[[<-} simply change the data without affecting other properties.
}
\examples{
ht <- huxtable(a = 1:3, b = letters[1:3])
ht[1:2,]
ht[,1]
ht$a
\dontrun{
rowspan(ht)[2,1] <- 2
ht[1:2,] # generates a warning
}
ht <- huxtable(a = 1:3, b = 1:3)
ht2 <- huxtable(10:11, 12:13)
bold(ht2) <- TRUE
ht[2:3,] <- ht2
ht
bold(ht)

}
