% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick-functions.R
\name{quick-output}
\alias{quick-output}
\alias{quick_pdf}
\alias{quick_html}
\alias{quick_docx}
\alias{quick_xlsx}
\title{Quickly create a PDF, HTML, Word or Excel document showing matrices, data frames, et cetera.}
\usage{
quick_pdf(..., file = confirm("huxtable-output.pdf"), borders = 0.4,
  open = interactive())

quick_html(..., file = confirm("huxtable-output.html"), borders = 0.4,
  open = interactive())

quick_docx(..., file = confirm("huxtable-output.docx"), borders = 0.4,
  open = interactive())

quick_xlsx(..., file = confirm("huxtable-output.xlsx"), borders = 0.4,
  open = interactive())
}
\arguments{
\item{...}{One or more huxtables or R objects with an \code{as_huxtable} method.}

\item{file}{File path for the output.}

\item{borders}{Border width for members of \code{...} that are not huxtables.}

\item{open}{Logical. Automatically open the resulting file?}
}
\value{
Invisible \code{NULL}.
}
\description{
Quickly create a PDF, HTML, Word or Excel document showing matrices, data frames, et cetera.
}
\details{
Objects in \code{...} will be converted to huxtables, with borders added.

If \sQuote{file} is not specified, the default file path is "huxtable-output.xxx" in
the working directory. If the session is interactive, you'll be asked to confirm any
overwrite; if the session is not interactive, the command will fail.
}
\examples{
\dontrun{
m <- matrix(1:4, 2, 2)
dfr <- data.frame(a = 1:5, b = 1:5)
quick_pdf(m, dfr)
quick_html(m, dfr)
quick_docx(m, dfr)
quick_xlsx(m, dfr)
}
}
