% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/screen.R
\name{print_screen}
\alias{print_screen}
\alias{to_screen}
\alias{to_screen.huxtable}
\title{Print a huxtable on screen}
\usage{
print_screen(ht, ...)

to_screen(ht, ...)

\method{to_screen}{huxtable}(ht,
  min_width = ceiling(getOption("width")/6),
  max_width = getOption("width", Inf), compact = TRUE,
  colnames = TRUE, color = getOption("huxtable.color_screen", default =
  TRUE), ...)
}
\arguments{
\item{ht}{A huxtable.}

\item{...}{Passed on to \code{to_screen}.}

\item{min_width}{Minimum width in on-screen characters of the result.}

\item{max_width}{Maximum width in on-screen characters of the result. Overrides \code{min_width}.}

\item{compact}{Logical. To save space, don't print lines for empty horizontal borders.}

\item{colnames}{Logical. Whether or not to print colum names.}

\item{color}{Logical. Whether to print the huxtable in color (requires the \code{crayon} package).}
}
\value{
\code{to_screen} returns a string. \code{print_screen} prints the string and returns \code{NULL}.
}
\description{
Print a huxtable on screen
}
\details{
\code{colspan}, \code{rowspan}, \code{align} and \code{caption} properties are shown. If the \code{crayon}
package is installed, output will be colorized (and contents bolded or italicized) by default;
this will work in recent daily builds of RStudio as of October 2017.
}
\examples{
ht <- huxtable(a = 1:5, b = 1:5, add_colnames = TRUE)
ht <- set_all_borders(ht, 1:6, 1:2, 1)
right_border(ht)[,1] <- left_border(ht)[,2] <- 0
align(ht)[1,] <- 'left'
print_screen(ht)
}
\seealso{
Other printing functions: \code{\link{print_html}},
  \code{\link{print_latex}}, \code{\link{print_md}}
}
\concept{printing functions}
