% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{valign}
\alias{valign}
\alias{valign<-}
\alias{set_valign}
\alias{map_valign}
\title{Vertical alignment}
\usage{
valign(ht)
valign(ht) <- value
set_valign(ht, row, col, value, byrow = FALSE)
map_valign(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector or matrix which may be "top", "middle", "bottom" or \code{NA}.

Set to \code{NA} to reset to the default, which is \code{"top"}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{valign}, the \code{valign} property.
For \code{set_valign} and \code{map_valign}, the modified huxtable.
}
\description{
Functions to get or set the \emph{vertical alignment} property of huxtable cells.
}
\details{
Vertical alignment may not work for short text in LaTeX. Defining row heights with \code{\link[=row_height]{row_height()}}
may help.
}
\examples{

orig <- valign(jams)
valign(jams) <-  "bottom"
valign(jams)

valign(jams) <- orig

jams2 <- set_valign(jams,
      "bottom")
valign(jams2)

jams3 <- set_valign(jams,
      2:3, 1, "bottom")
valign(jams3)

jams4 <- map_valign(jams,
      by_rows(
        "bottom",
        "bottom")
      )
valign(jams4)
}
