% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/package-docs.R
\docType{package}
\name{huxtable-package}
\alias{huxtable-package}
\title{Quick introduction to huxtable}
\description{
Huxtable is a package for creating HTML and LaTeX tables. It provides similar
functionality to xtable, with a simpler interface.
}
\section{Quick start}{


To create a huxtable object, use \code{\link[=huxtable]{huxtable()}} or \code{\link[=as_huxtable]{as_huxtable()}}:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ library(huxtable)
 employees <- huxtable(
         Names    = c("Hadley", "Yihui", "Dirk"),
         Salaries = c(1e5, 1e5, 1e5),
         add_colnames = TRUE
       )
 car_hux <- as_hux(mtcars)

}\if{html}{\out{</div>}}

You can then set properties which affect how the huxtable is displayed:

\if{html}{\out{<div class="sourceCode">}}\preformatted{ # make the first row bold:
 bold(employees)[1, ] <- TRUE

 # change the font size everywhere:
 font_size(employees) <- 10
}\if{html}{\out{</div>}}

Or you can use a tidyverse style with the pipe operator:

\if{html}{\out{<div class="sourceCode">}}\preformatted{library(magrittr)
employees <- employees \%>\%
      set_font_size(10) \%>\%
      set_bold(1, everywhere, TRUE)

}\if{html}{\out{</div>}}

For more information, see \href{https://hughjonesd.github.io/huxtable/}{the website} or
read the vignette with \code{vignette('huxtable')}.

See \link{huxtable-FAQ} for frequently asked questions, including ways to get
help.

To report a bug, or suggest an enhancement, visit
\href{https://github.com/hughjonesd/huxtable/issues}{github}.
}

