% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-cell.R
\name{spans}
\alias{spans}
\alias{rowspan}
\alias{rowspan<-}
\alias{set_rowspan}
\alias{map_rowspan}
\alias{colspan}
\alias{colspan<-}
\alias{set_colspan}
\alias{map_colspan}
\title{Extend cells over multiple rows and/or columns}
\usage{
rowspan(ht)
rowspan(ht) <- value
set_rowspan(ht, row, col, value )
map_rowspan(ht, row, col, fn)

colspan(ht)
colspan(ht) <- value
set_colspan(ht, row, col, value )
map_colspan(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{value}{An integer vector or matrix.}
}
\description{
A cell with rowspan of 2 covers the cell directly below it. A cell with
colspan of 2 covers the cell directly to its right. A cell with rowspan of 2
and colspan of 2 covers a 2 x 2 square, hiding three other cells.
}
\section{Cell content}{

In merged cell ranges, only the top left cell's content is displayed.
In addition, when you merge cells (either by setting \code{\link[=colspan]{colspan()}} or
\code{\link[=rowspan]{rowspan()}}, or using \code{\link[=merge_cells]{merge_cells()}} and friends) the content of the top
left cell is copied to other cells. This prevents unexpected changes to
content if you reorder or subset rows and columns.
}

\examples{

letter_hux <- as_hux(matrix(LETTERS[1:9], 3, 3))
letter_hux <- set_all_borders(letter_hux)
letter_hux
set_rowspan(letter_hux, 1, 1, 2)
set_colspan(letter_hux, 1, 1, 2)

}
\seealso{
\code{\link[=merge_cells]{merge_cells()}}, \code{\link[=merge_across]{merge_across()}} and \code{\link[=merge_down]{merge_down()}} for
a higher-level interface.
}
