% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manningc.R
\name{manningc}
\alias{manningc}
\title{Solves the Manning Equation for gravity flow in a circular pipe}
\usage{
manningc(
  Q = NULL,
  n = NULL,
  Sf = NULL,
  y = NULL,
  d = NULL,
  y_d = NULL,
  units = c("SI", "Eng")
)
}
\arguments{
\item{Q}{numeric vector that contains the flow rate [m^3/s or or ft^3/s]}

\item{n}{numeric vector that contains the Manning roughness coefficient.}

\item{Sf}{numeric vector that contains the slope of the pipe [unitless]}

\item{y}{numeric vector that contains the water depth [m or ft]}

\item{d}{numeric vector that contains the pipe diameter [m or ft]}

\item{y_d}{numeric vector that contains the ratio of depth to diameter [unitless]}

\item{units}{character vector that contains the system of units [options are
\code{SI} for International System of Units and \code{Eng} for English (US customary)
units. This is used for compatibility with iemisc package]}
}
\value{
Returns a list including the missing parameter:
\itemize{
  \item Q - flow rate
  \item V - flow velocity
  \item A - cross-sectional area of flow
  \item P - wetted perimeter
  \item R - hydraulic radius
  \item y - flow depth
  \item d - pipe diameter
  \item Sf - slope
  \item n - Manning's roughness
  \item Fr - Froude number
  \item Re - Reynolds number
  \item Qf - Full pipe flow rate
}
}
\description{
This function solves the Manning equation for water
flow in a circular pipe at less than full. This is a modification of the
comprehensive code prepared by Irucka Embry in his iemisc package. Specifically
the iemisc::manningcirc function was adapted here for more limited cases
commonly used in classroom exercises, additional checks were included to ensure
the pipe is flowing less than full, and a cross-section figure is also
available. The iemisc::manningcirc and iemisc::manningcircy sunctions were also
combined into a single function.
}
\details{
The possible applications of this function for solving the Manning equation
for circular pipes are:
\tabular{ll}{
  \strong{Given} \tab \strong{Solve for} \cr
  y_d, Q, Sf, n \tab d \cr
  d, Sf, Q, n \tab y \cr
  y, d, Q, n \tab Sf \cr
  y, d, Sf, n \tab Q \cr
  d, Q, Sf, y \tab n
}
}
\examples{

#Solving for flow rate, Q: SI Units
manningc(d = 0.6, n = 0.013, Sf = 1./400., y = 0.24, units = "SI")
#returns 0.1 m3/s

#Solving for Sf, if d=600 mm and pipe is to flow half full
manningc(d = 0.6, Q = 0.17, n = 0.013, y = 0.3, units = "SI")
#returns required slope of 0.003

#Solving for diameter, d when given y_d): Eng (US) units
manningc(Q = 83.5, n = 0.015, Sf = 0.0002, y_d = 0.9, units = "Eng")
#returns 7.0 ft required diameter

}
\author{
Ed Maurer, Irucka Embry
}
