% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/01_hm.R
\docType{class}
\name{hydromet-class}
\alias{hydromet-class}
\alias{hydromet}
\title{\code{hydromet} superclass object}
\value{
A basic hydromet class object. This class is provided in order to set the meta-data of the station.
}
\description{
A suitable object for store basic information about an hydro-meteorological station.
}
\section{Slots}{

\describe{
\item{\code{id}}{ANY. This is the ID assigned by the agency.}

\item{\code{agency}}{string. The name of the agency (or institution) that provides the data of the station.}

\item{\code{station}}{string. The name of the (hydro)-meteorological station.}

\item{\code{lat}}{numeric. Latitude of the station.}

\item{\code{long}}{numeric. Longitude of the station}

\item{\code{alt}}{numeric. Altitude of the station.}

\item{\code{country}}{string. Country where the station is located. Argentina is set as default value.}

\item{\code{province}}{string. Name of the province where the station is located. Mendoza is set as default value.}

\item{\code{river}}{string. Basin river's name.}

\item{\code{active}}{logical. It indicates whether or not the station is currently operated. Default value is \code{TRUE}.}

\item{\code{basin_area}}{numeric. The basin area (km2) of the catchment upstream of the gauge.}

\item{\code{basin_eff}}{numeric. The effective area (km2) of the basin upstream of the gauge. In Canada, many basins have
variable contributing fractions. In these basins, the effective area of the basin contributes flow to the outlet at
least one year in two.}

\item{\code{other_1}}{ANY. It is the first free-to-fill slot in order to give you the chance to write extra information about your
hydro-met station.}

\item{\code{other_2}}{ANY. It is the second free-to-fill slot in order to give you the chance to write extra information about your
hydro-met station.}
}}

