% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CIARsample.R
\name{CIAR.sample}
\alias{CIAR.sample}
\title{Simulate from a CIAR Model}
\usage{
CIAR.sample(n, sT, phi.R, phi.I, rho = 0, c = 1)
}
\arguments{
\item{n}{Length of the output time series. A strictly positive integer.}

\item{sT}{Array with observational times.}

\item{phi.R}{Real part of the coefficient of CIAR model. A value between -1 and 1.}

\item{phi.I}{Imaginary part of the coefficient of CIAR model. A value between -1 and 1.}

\item{rho}{Correlation between the real and the imaginary part of the process. A value between -1 and 1.}

\item{c}{Nuisance parameter corresponding to the variance of the imaginary part.}
}
\value{
A list with the following components:
\itemize{
\item{y}{Array with the simulated real part of the CIAR process.}
\item{t}{ Array with observation times.}
\item{Sigma}{ Covariance matrix of the process.}
}
}
\description{
Simulates a CIAR Time Series Model
}
\details{
The chosen phi.R and phi.I values must satisfy the condition $|phi.R + i phi.I| < 1$.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
x=CIAR.sample(n=n,phi.R=0.9,phi.I=0,sT=st,c=1)
plot(st,x$y,type='l')
x=CIAR.sample(n=n,phi.R=-0.9,phi.I=0,sT=st,c=1)
plot(st,x$y,type='l')
}
\references{
\insertRef{Elorrieta_2019}{iAR}
}
\seealso{
\code{\link{gentime}}
}
