% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/F031.gene.plot.R
\name{gene.plot}
\alias{gene.plot}
\title{Make scatter, box and bar plots for genes}
\usage{
gene.plot(x = NULL, gene = "NULL", cond.shape = FALSE,
  data.type = "main", box.to.test = 0, box.pval = "sig.signs",
  plot.data.type = "tsne", scaleValue = FALSE, min.scale = -2.5,
  max.scale = 2.5, clust.dim = 2, col.by = "clusters",
  plot.type = "scatterplot", cell.size = 1, cell.colors = c("gray",
  "red"), box.cell.col = "black", box.color = "red",
  box.line.col = "green", back.col = "white",
  cell.transparency = 0.5, interactive = TRUE, out.name = "plot")
}
\arguments{
\item{x}{An object of class iCellR.}

\item{gene}{A gene name to be plotted.}

\item{cond.shape}{If TRUE the conditions will be shown in shapes.}

\item{data.type}{Choose from "main" or "imputed", default = "main".}

\item{box.to.test}{A cluster number so that all the boxes in the box plot would be compared to. If set to "0" the cluster with the highest avrage would be choosen, default = 0.}

\item{box.pval}{Choose from "sig.values" and "sig.signs". If set to "sig.signs" p values would be replaced with signs ("na", "*", "**", "***"), default = "sig.signs".}

\item{plot.data.type}{Choose between "tsne", "pca", "umap", "diffusion", "pseudo.A" and "pseudo.B", default = "tsne".}

\item{scaleValue}{Scale the colors, default = FALSE.}

\item{min.scale}{If scaleValue = TRUE, set a number for min, default = -2.5.}

\item{max.scale}{If scaleValue = TRUE, set a number for max, default = 2.5.}

\item{clust.dim}{2 for 2D plots and 3 for 3D plots, default = 2.}

\item{col.by}{Choose from "clusters" and "conditions", default = "clusters".}

\item{plot.type}{Choose from "scatterplot", "boxplot" and "barplot", default = "scatterplot".}

\item{cell.size}{A number for the size of the points in the plot, default = 1.}

\item{cell.colors}{Colors for heat mapping the points in "scatterplot", default = c("gray","red").}

\item{box.cell.col}{A color for the points in the box plot, default = "black".}

\item{box.color}{A color for the boxes in the "boxplot", default = "red".}

\item{box.line.col}{A color for the lines around the "boxplot", default = "green".}

\item{back.col}{A color for the plot background, default = "black".}

\item{cell.transparency}{Color transparency for points in "scatterplot" and "boxplot", default = 0.5.}

\item{interactive}{If set to TRUE an interactive HTML file will be created, default = TRUE.}

\item{out.name}{If "interactive" is set to TRUE, the out put name for HTML, default = "plot".}
}
\value{
An object of class iCellR.
}
\description{
This function takes an object of class iCellR and provides plots for genes.
}
\examples{
gene.plot(demo.obj, gene = "CD74",interactive = FALSE)

gene.plot(demo.obj, gene = "CD74",plot.data.type = "umap",interactive = FALSE)

gene.plot(demo.obj, gene = "CD74",
          plot.data.type = "umap",
          interactive = FALSE,
          plot.type = "barplot")

gene.plot(demo.obj, gene = "CD74",
          plot.data.type = "umap",
          interactive = FALSE,
          plot.type = "boxplot")

}
