\name{iClick.ARIMA}
\alias{iClick.ARIMA}
\title{
iClick GUI for ARIMA
}

\encoding{latin1}


\description{
This GUI estimates ARIMA both with automatic lag selection and fixed lag length. The GUI is only only a GUI, but also a output format.
}
\usage{
iClick.ARIMA(dat, AR = 1, MA = 1, n.ahead = 24, ic = "aic")
}

\arguments{
  \item{dat}{
dat has two forms:(1) It may be a 2-column data frame, with the 1-st column as the date string, and the 2nd column is the numeric return series. (2) It can also be created by a ts() object as a none daily time series. However, the ts object may not be suitable for some financial time series returns plot, for example, drawdown.
}
  \item{AR}{
Pre-specified fixed AR order.
}
  \item{MA}{
Pre-specified fixed MA order.
}
  \item{n.ahead}{
Periods of out-of-sample forecast.
}
  \item{ic}{
Information criteria for lag selection,ic=c("aicc", "aic", "bic"). See auto.arima() of package forecast.
}
}
\details{
This GUI fits two ARMA, fixed orders and automatically fitted orders, and returns a two-part GUI with output on it. The outputs can be saved as .RData file for later use, the last row is the save button.\cr
The saved filename is automatically generated by selections and results; for example, .aicOrderARIMA_102.RData represents the automatically fits ARIMA(p,d,q) orders are ARIMA(1,0,2) by AIC.\cr Using load(".aicOrderARIMA_102.RData") to retrieve the file and ls() to list objects, and use names() to show details of objects.\cr
The input returns data must be in percentage form; namely, dlog()*100
}
\value{
Fitted ARMA regression output.
}

\author{
Ho Tsung-wu <tsungwu@mail.shu.edu.tw>
}

\seealso{
arima() and auto.arima() of package forecast.
}

\examples{

##External data
#data("returnsDaily24")
#y=returnsDaily24[,c(1,5)]

## Simulation data
dat=rnorm(100,5,1)
y=ts(dat, start = c(1970, 1), frequency = 12)

iClick.ARIMA(y)

#More
#iClick.ARIMA(y,AR = 2, MA = 2, n.ahead = 12, ic = "bic")

}

