% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_create_empty_manual_file.R
\name{ifcb_create_empty_manual_file}
\alias{ifcb_create_empty_manual_file}
\title{Create an Empty Manual Classification MAT File}
\usage{
ifcb_create_empty_manual_file(
  roi_length,
  class2use,
  output_file,
  unclassified_id = 1,
  do_compression = TRUE
)
}
\arguments{
\item{roi_length}{Integer. The number of rows in the class list (number of ROIs).}

\item{class2use}{Character vector. The names of the classes to include in the \code{class2use_manual} field of the MAT file.}

\item{output_file}{Character. The path where the output MAT file will be saved.}

\item{unclassified_id}{Integer. The value to use in the second column of the class list. Default is 1.}

\item{do_compression}{A logical value indicating whether to compress the .mat file. Default is TRUE.}
}
\value{
No return value. This function is called for its side effects.
The created MAT file is saved at the specified \code{output_file} location.
}
\description{
Generates a MAT file for IFCB data with an empty manual classification structure using a specified number of ROIs,
class names, and saves it to a specified output file. This function utilizes a Python script for creating the structure.
}
\details{
This function requires a python interpreter to be installed. The required python packages can be installed in a virtual environment using \code{ifcb_py_install}.
}
\examples{
\dontrun{
# Initialize a python session if not already set up
ifcb_py_install()

# Create a MAT file with 100 ROIs, using a vector of class names, and save it to "output.mat"
ifcb_create_empty_manual_file(roi_length = 100,
                              class2use = c("unclassified", "Aphanizomenon_spp"),
                              output_file = "output.mat")

# Create a MAT file with a different unclassified_id
ifcb_create_empty_manual_file(roi_length = 100,
                              class2use = c("unclassified", "Aphanizomenon_spp"),
                              output_file = "output.mat",
                              unclassified_id = 999)
}

}
