% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_volume_analyzed_from_adc.R
\name{ifcb_volume_analyzed_from_adc}
\alias{ifcb_volume_analyzed_from_adc}
\title{Estimate Volume Analyzed from IFCB ADC File}
\usage{
ifcb_volume_analyzed_from_adc(adc_file)
}
\arguments{
\item{adc_file}{A character vector specifying the path(s) to one or more .adc files or URLs.}
}
\value{
A list containing:
\itemize{
\item \strong{ml_analyzed}: A numeric vector of estimated sample volume analyzed for each ADC file.
\item \strong{inhibittime}: A numeric vector of inhibittime values extracted from ADC files.
\item \strong{runtime}: A numeric vector of runtime values extracted from ADC files.
}
}
\description{
This function reads an IFCB ADC file to extract sample run time and inhibittime,
and returns the associated estimate of sample volume analyzed (in milliliters).
The function assumes a standard IFCB configuration with a sample syringe operating
at 0.25 mL per minute. For IFCB instruments after 007 and higher (except 008). This is
the R equivalent function of \code{IFCB_volume_analyzed_fromADC} from the \verb{ifcb-analysis repository} (Sosik and Olson 2007).
}
\examples{
\dontrun{
# Example: Estimate volume analyzed from an IFCB ADC file
adc_file <- "path/to/IFCB_adc_file.csv"
adc_info <- ifcb_volume_analyzed_from_adc(adc_file)
print(adc_info$ml_analyzed)
}
}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\url{https://github.com/hsosik/ifcb-analysis}
}
