% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{run.permutations}
\alias{run.permutations}
\title{Permutations for significance testing}
\usage{
run.permutations(config_matrices, nperm = 1000)
}
\arguments{
\item{config_matrices}{The result from compute.config.matrices().}

\item{nperm}{The number of permutations to perform (default=1000).}
}
\value{
An n x n x nperms array of RV coefficients for the permutated data, where n is the number of datasets.
}
\description{
Performs a permutations for significance testing. The result from this function can be used with
rv.pval() to determine a p-value. By decoupling this into two functions,
you don't have to redo the permutations for every p-value, hence increasing the runtime speed.
}
\examples{
set.seed(2)
n = 100
p = 100
x1 = matrix(rnorm(n*p), n, p)
x2 = x1 + matrix(rnorm(n*p), n, p)
x3 = x2 + matrix(rnorm(n*p), n, p)
data = list(x1=x1, x2=x2, x3=x3)
config_matrices = compute.config.matrices(data)
cors = rv.cor.matrix(config_matrices)
cors_perm = run.permutations(config_matrices, nperm=1000)
rv.pval(cors, cors_perm, "x1", "x3", "x2")
}
