% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/realisedCoeffs.R
\name{realised}
\alias{realised}
\alias{realisedInbreeding}
\alias{realisedKinship}
\alias{realisedKappa}
\alias{realisedIdentity}
\title{Realised relatedness}
\usage{
realisedInbreeding(sims, id = NULL, unit = "cm")

realisedKinship(sims, ids = NULL, unit = "cm")

realisedKappa(sims, ids = NULL, unit = "cm")

realisedIdentity(sims, ids = NULL, unit = "cm")
}
\arguments{
\item{sims}{A list of genome simulations, as output by \code{\link[=ibdsim]{ibdsim()}}.}

\item{id, ids}{A vector with one or two ID labels.}

\item{unit}{Either "mb" (megabases) or "cm" (centiMorgan); the length unit
for genomic segments. Default is "cm", which normally gives lower variance.}
}
\description{
Compute the realised values of various pedigree coefficients, from simulated
data. The current implementation covers inbreeding coefficients for single
pedigree members, and kinship, kappa and condensed identity coefficients for
pairwise relationships.
}
\details{
The inbreeding coefficient \eqn{f} of a pedigree member is defined as the
probability of autozygosity (homozygous for alleles that are identical by
descent) in a random autosomal locus. Equivalently, the inbreeding
coefficient is the \emph{expected} autozygous proportion of the autosomal
chromosomes.

The \emph{realised} inbreeding coefficient \eqn{f_R} in a given individual is the
actual fraction of the autosomes covered by autozygous segments. Because of
the stochastic nature of meiotic recombination, this may deviate
substantially from the pedigree-based expectation.

Similarly, the pedigree-based IBD coefficients \eqn{\kappa_0, \kappa_1,
\kappa_2} of noninbred pairs of individuals have realised counterparts. For
any given pair of individuals we define \eqn{k_i} to be the actual fraction
of the autosome where the individuals share exactly \eqn{i} alleles IBD,
where \eqn{i = 0,1,2}.

Finally, we can do the same thing for each of the nine condensed identity
coefficients of Jacquard. For each \eqn{i = 1,...,9} we define \eqn{D_i} the
be the fraction of the autosome where a given pair of individuals are in
identity state \eqn{i}. This uses the conventional ordering of the nine
condensed identity states; see for instance the \href{https://github.com/magnusdv/ribd}{\code{ribd} GitHub page}.
}
\examples{

# Realised IBD coefficients between full siblings
x = nuclearPed(2)
s = ibdsim(x, N = 2) # increase N
realisedKappa(s, ids = 3:4)

###########

# Realised inbreeding coefficients, child of first cousins
x = cousinPed(1, child = TRUE)
s = ibdsim(x, N = 2) # increase N
realisedInbreeding(s, id = 9)

# Same data: realised kinship coefficients between the parents
realisedKinship(s, ids = parents(x, 9))

###########

# Realised identity coefficients after full sib mating
x = fullSibMating(1)
s = ibdsim(x, N = 2) # increase N
realisedIdentity(s, ids = 5:6)

}
