% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{.attr_decimal_diag}
\alias{.attr_decimal_diag}
\alias{.attr_short_diag}
\alias{as.icd_decimal_diag}
\alias{as.icd_short_diag}
\title{Set ICD short-form diagnosis code attribute}
\usage{
.attr_decimal_diag(x, value = TRUE)

.attr_short_diag(x, value = TRUE)

as.icd_short_diag(x, value = TRUE)

as.icd_decimal_diag(x, value = TRUE)
}
\description{
Doing this in an R function doesn't work for 'void' equivalent, and does a
copy if the updated object is returned.
}
\examples{
j <- "100"
attr(j, "icd_short_diag") <- TRUE
j
attr(j, "icd_short_diag") <- FALSE
j
icd:::.attr_decimal_diag(j)
as.icd_decimal_diag(j)
\dontrun{
library(pryr)
j <- 1
c(address(j), refs(j))
attr(j, "icd_short_diag") <- TRUE
c(address(j), refs(j))
attr(j, "icd_short_diag") <- FALSE
c(address(j), refs(j))
icd:::.attr_decimal_diag(j)
c(address(j), refs(j))
j <- as.icd_decimal_diag(j, TRUE)
c(address(j), refs(j))
# Rcpp cleverer than R, and doesn't return a copy of the data
}
}
\keyword{attribute}
\keyword{internal}

