# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Convert \code{mjr} and \code{mnr} vectors to single code
#'
#' In debug mode, will check that \code{mjr} and \code{mnr} are same length.
#' @template mjr
#' @template mnr
#' @template isShort
#' @return Character vector
#' @keywords internal manip
icd9MajMinToCode <- function(mjr, mnr, isShort) {
    .Call(`_icd_icd9MajMinToCode`, mjr, mnr, isShort)
}

icd9MajMinToShort <- function(mjr, mnr) {
    .Call(`_icd_icd9MajMinToShort`, mjr, mnr)
}

icd9MajMinToDecimal <- function(mjr, mnr) {
    .Call(`_icd_icd9MajMinToDecimal`, mjr, mnr)
}

#' Set ICD short-form diagnosis code attribute
#'
#' Doing this in an R function doesn't work for 'void' equivalent, and does a
#' copy if the updated object is returned.
#' @examples
#' j <- "100"
#' attr(j, "icd_short_diag") <- TRUE
#' j
#' attr(j, "icd_short_diag") <- FALSE
#' j
#' icd:::attr_decimal_diag(j)
#' as.decimal_diag(j)
#' # if pryr is installed, use address and refs to see what is going on
#' @keywords internal attribute
attr_decimal_diag <- function(x, value = TRUE) {
    invisible(.Call(`_icd_setDecimalDiag`, x, value))
}

#' Set short diagnosis flag in C++
#' @param x Any R object
#' @param value \code{TRUE} or \code{FALSE}
#' @keywords internal attribute
attr_short_diag <- function(x, value = TRUE) {
    invisible(.Call(`_icd_setShortDiag`, x, value))
}

categorize_rcpp <- function() {
    .Call(`_icd_categorize_rcpp`)
}

icd10cm_children_defined_cpp <- function(x, icd10cm2016, nc) {
    .Call(`_icd_icd10cmChildrenDefined`, x, icd10cm2016, nc)
}

#' @title Internal function to simplify a comorbidity map by only including
#'   codes which are parents, or identical to, a given list of codes.
#' @description Specifically, this is useful for ICD-10 codes where there are a
#' huge number of possible codes, but we do not want to make a comorbidity map
#' with such a large number of codes in it.
#' @param x Character vector (not factor)
#' @template mapping
#' @template visit_name
#' @template icd_name
#' @seealso \url{https://github.com/s-u/fastmatch/blob/master/src/fastmatch.c}
#' @examples
#' # one exact match, next cmb parent code, next cmb child code
#' icd10 <- as.icd10(c("I0981", "A520", "I26019"))
#' pts <- data.frame(visit_id = c("a", "b", "c"), icd10)
#' simple_map <- icd:::simplify_map_lex(icd10, icd10_map_ahrq)
#' stopifnot(simple_map$CHF == "I0981")
#' stopifnot(simple_map$PHTN != character(0))
#' stopifnot(simple_map$PVD == "I26019")
#' umap <- icd:::simplify_map_lex(uranium_pathology$icd10, icd10_map_ahrq)
#' head(icd:::categorize_simple(uranium_pathology, icd10_map_ahrq,
#'                       id_name = "case", code_name = "icd10"))
#' head(icd:::categorize_simple(uranium_pathology, umap,
#'                              id_name = "case", code_name = "icd10"))
#' @keywords internal
simplify_map_lex <- function(pt_codes, map) {
    .Call(`_icd_simplifyMapLexicographic`, pt_codes, map)
}

#' @title Comorbidity calculation as a matrix multiplication
#' @description
#' The problem is that the matrices could be huge: the patient-icd matrix would
#' be millions of patient rows, and ~15000 columns for all AHRQ comorbidities.
#' @details
#' Several ways of reducing the problem: firstly, as with existing code, we can
#' drop any ICD codes from the map which are not in the patient data. With many
#' patients, this will be less effective as the long tail becomes apparent.
#' However, with the (small) Vermont data, we see ~15,000 codes being reduced to
#' 339.
#' @section Sparse matrices:
#' Using sparse matrices is another solution. Building
#' the initial matrix may become a significant part of the calculation, but once
#' done, the solution could be a simple matrix multiplication, which is
#' potentially highly optimized (Eigen, BLAS, GPU, etc.)
#' @section Eigen:
#' Eigen has parallel (non-GPU) optimized sparse row-major *
#' dense matrix. Patients-ICD matrix must be the row-major sparse one, so the
#' dense matrix is then the comorbidity map
#' \url{https://eigen.tuxfamily.org/dox/TopicMultiThreading.html}
#' @keywords internal array algebra
comorbidMatMulSimple <- function(icd9df, icd9Mapping, visitId, icd9Field) {
    .Call(`_icd_comorbidMatMulSimple`, icd9df, icd9Mapping, visitId, icd9Field)
}

icd9PartsToShort <- function(parts) {
    .Call(`_icd_icd9PartsToShort`, parts)
}

icd9PartsToDecimal <- function(parts) {
    .Call(`_icd_icd9PartsToDecimal`, parts)
}

icd9MajMinToParts <- function(mjr, mnr) {
    .Call(`_icd_icd9MajMinToParts`, mjr, mnr)
}

icd9ShortToPartsCpp <- function(icd9Short, mnrEmpty) {
    .Call(`_icd_icd9ShortToPartsCpp`, icd9Short, mnrEmpty)
}

#' @describeIn decimal_to_parts Convert short ICD-10 code to parts
#' @export
#' @keywords internal manip
short_to_parts.icd10 <- function(x, mnr_empty = "") {
    .Call(`_icd_icd10ShortToPartsCpp`, x, mnr_empty)
}

icd9DecimalToPartsCpp <- function(icd9Decimal, mnr_empty) {
    .Call(`_icd_icd9DecimalToPartsCpp`, icd9Decimal, mnr_empty)
}

#' @describeIn decimal_to_parts Convert decimal ICD-10 code to parts. This
#'   shares almost 100% code with the ICD-9 version: someday combine the common
#'   code.
#' @export
#' @keywords internal manip
decimal_to_parts.icd10 <- function(x, mnr_empty = "") {
    .Call(`_icd_icd10DecimalToPartsCpp`, x, mnr_empty)
}

icd9_short_to_decimal_cpp <- function(x) {
    .Call(`_icd_icd9ShortToDecimal`, x)
}

icd9_decimal_to_short_cpp <- function(x) {
    .Call(`_icd_icd9DecimalToShort`, x)
}

#' @describeIn get_major Get major part of ICD-9 code, i.e. first three
#'   digits of numeric or V code, or first four digits of E code. This is the
#'   part before the decimal, when a decimal point is used.
#' @keywords internal manip
#' @export
get_major.icd9 <- function(x, short_code) {
    .Call(`_icd_icd9GetMajor`, x, short_code)
}

#' @title Convert integers to strings as quickly as possible
#' @description Have tried R, `sprintf` with \pkg{Rcpp} and C++ standard
#' library. Doesn't do bounds checking, but limited by length of integers.
#' @param x Vector of integers
#' @return Vector of characters
#' @md
#' @keywords internal manip
fastIntToStringRcpp <- function(x) {
    .Call(`_icd_fastIntToStringRcpp`, x)
}

guessShortPlusFactorCpp <- function(x_, n = 1000L) {
    .Call(`_icd_guessShortPlusFactorCpp`, x_, n)
}

#' Guess whether codes are \code{short_code} or \code{decimal_code}
#'
#' The goal is to guess whether codes are \code{short_code} or
#' \code{decimal_code} form. Currently condense works, but not with the
#' \code{icd} look-up table currently in use. Of note, validation is a bit
#' different here, since we don't know the type until after we guess. We could
#' look for where both short_code and long are invalid, and otherwise assume
#' valid, even if the bulk are short_code. However, it may be more useful to
#' check validity after the guess.
#' @details Very quick heuristic, ploughs through ten million codes in less
#'   than one second and will stop more quickly if it finds a '.'.
#' @return single logical value, \code{TRUE} if input data are predominantly
#'   \code{short_code} type. If there is some uncertainty, then return
#'   \code{NA}.
#' @keywords internal
guess_short <- function(x_, short_code = NULL, n = 1000L, icd_name = NULL) {
    .Call(`_icd_guessShortCompleteCpp`, x_, short_code, n, icd_name)
}

#' Do elements of vector begin with V, E (or any other character)?
#'
#' Currently returns a vector of \code{bool} which is not thread safe, or
#' particularly fast, although it is memory efficient in the standard
#' implementation. As of \code{icd9} (now known as \code{icd}) version 1.2,
#' this is not called by threaded code, but this could change, so beware! ASCII
#' spaces are trimmed from the start of the string before testing, but no other
#' white space
#' @param sv vector of strings
#' @param x \code{const char*} of choices of first character to match
#' @param invert single logical, if TRUE, negates the condition
#' @keywords internal
icd9_is_n_cpp <- function(sv) {
    .Call(`_icd_icd9_is_n_cpp`, sv)
}

#' @rdname icd9_is_n_cpp
#' @keywords internal
icd9_is_v_cpp <- function(sv) {
    .Call(`_icd_icd9_is_v_cpp`, sv)
}

#' @rdname icd9_is_n_cpp
#' @keywords internal
icd9_is_e_cpp <- function(sv) {
    .Call(`_icd_icd9_is_e_cpp`, sv)
}

long_to_wide_cpp <- function(icd9df, visitId, icd9Field, aggregate = TRUE) {
    .Call(`_icd_longToWideCpp`, icd9df, visitId, icd9Field, aggregate)
}

#' Simpler add leading zeroes without converting to parts and back
#' @keywords internal manip
icd9AddLeadingZeroesMajorSingle <- function(mjr) {
    .Call(`_icd_icd9AddLeadingZeroesMajorSingle`, mjr)
}

icd9AddLeadingZeroesMajorSingleStd <- function(m) {
    .Call(`_icd_icd9AddLeadingZeroesMajorSingleStd`, m)
}

icd9_add_leading_zeroes_major <- function(mjr) {
    .Call(`_icd_icd9AddLeadingZeroesMajor`, mjr)
}

#' @title Add leading zeroes to incomplete ICD-9 codes
#' @description Non-decimal ICD-9 codes with length<5 are often ambiguous. E.g.
#'   100 could be 1.00 10.0 or 100 if coded incorrectly. We must assume 100 is
#'   really 100
#' @param x Character vector of ICD-9 codes
#' @template short_code
#' @return character vector of ICD-9 codes with leading zeroes
#' @keywords internal manip
icd9_add_leading_zeroes_cpp <- function(x, short_code) {
    .Call(`_icd_icd9AddLeadingZeroes`, x, short_code)
}

icd9_expand_minor_wrap <- function(mnr, isE) {
    .Call(`_icd_icd9ExpandMinor`, mnr, isE)
}

icd9ChildrenShort <- function(icd9Short, icd9cmReal, onlyReal) {
    .Call(`_icd_icd9ChildrenShort`, icd9Short, icd9cmReal, onlyReal)
}

icd9ChildrenShortUnordered <- function(icd9Short, icd9cmReal, onlyReal) {
    .Call(`_icd_icd9ChildrenShortUnordered`, icd9Short, icd9cmReal, onlyReal)
}

icd9ChildrenDecimalCpp <- function(icd9Decimal, icd9cmReal, onlyReal) {
    .Call(`_icd_icd9ChildrenDecimalCpp`, icd9Decimal, icd9cmReal, onlyReal)
}

icd9ChildrenCpp <- function(icd9, isShort, icd9cmReal, onlyReal = TRUE) {
    .Call(`_icd_icd9ChildrenCpp`, icd9, isShort, icd9cmReal, onlyReal)
}

#' @describeIn factor_nosort \pkg{Rcpp} implementation, requiring character
#' vector inputs only, no argument checking.
#' @keywords internal manip
factor_nosort_rcpp_worker <- function(x, levels, na_rm) {
    .Call(`_icd_factorNoSort`, x, levels, na_rm)
}

#' @title Re-generate a factor with new levels, without doing string matching
#' @description This is called by an R wrapper. There is an `na.rm` version,
#' too.
#' @md
#' @keywords internal manip
refactor_worker <- function(x, new_levels, exclude_na) {
    .Call(`_icd_refactor`, x, new_levels, exclude_na)
}

#' @describeIn refactor_worker Drop all `NA` values from levels and values
#' @keywords internal
refactor_narm_worker <- function(x, new_levels) {
    .Call(`_icd_refactor_narm`, x, new_levels)
}

trimLeftCpp <- function(s) {
    .Call(`_icd_trimLeftCpp`, s)
}

strimCpp <- function(s) {
    .Call(`_icd_strimCpp`, s)
}

trimCpp <- function(sv) {
    .Call(`_icd_trimCpp`, sv)
}

icd9_order_cpp <- function(x) {
    .Call(`_icd_icd9OrderCpp`, x)
}

#' @title Faster match
#' @name match_rcpp
#' @keywords internal
match_rcpp <- function(x, table) {
    .Call(`_icd_matchFast`, x, table)
}

#' @describeIn match_rcpp Use faster matching for %in% equivalent.
#' @keywords internal
fin <- function(x, table) {
    .Call(`_icd_inFast`, x, table)
}

valgrindCallgrindStart <- function(zerostats = FALSE) {
    .Call(`_icd_valgrindCallgrindStart`, zerostats)
}

valgrindCallgrindStop <- function() {
    .Call(`_icd_valgrindCallgrindStop`)
}

