% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{download_all_icd_data}
\alias{download_all_icd_data}
\title{Download all the additional data at once}
\usage{
download_all_icd_data()
}
\description{
It will download and parse WHO ICD-10, French, and Belgian codes and
descriptions. It will also get years 2014, 2015, 2017, and 2018 for ICD-10-CM
(diagnostic codes), and 2014--2019 procedure codes. 2016 and 2019 diagnostic
codes are included in the package data. The total amount of data is about
340Mb. It is not necessary to do call \code{download_all_icd_data} for normal
use: you may simply call the functions like \code{get_icd10cm2014}, which
will download data when needed.
}
\examples{
\dontrun{
set_icd_data_dir()
# or configure a directory to us:
# options("icd.data.resource" = "/tmp/icd")
# or
# set_icd_data_dir("/tmp/icd")

# The following would download, and make all the known ICD data available
# download_all_icd_data()
}
}
\seealso{
\code{\link{set_icd_data_dir}}
}
