% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/manip.R
\name{icd9DropLeadingZeroes}
\alias{icd9DropLeadingZeroes}
\alias{icd9DropLeadingZeroesDecimal}
\alias{icd9DropLeadingZeroesMajor}
\alias{icd9DropLeadingZeroesShort}
\title{drop zero padding from decimal ICD-9 code.}
\usage{
icd9DropLeadingZeroes(icd9, isShort)

icd9DropLeadingZeroesDecimal(icd9Decimal)

icd9DropLeadingZeroesShort(icd9Short)

icd9DropLeadingZeroesMajor(major)
}
\arguments{
\item{icd9}{is
a character vector or factor of ICD-9 codes. If fewer than five characters
is given in a code, then the digits are greedily assigned to hundreds, then
tens, then units, before the decimal parts. E.g. "10" becomes "010", not
"0010".}

\item{icd9Decimal}{character vector of ICD-9 codes. If fewer than five
characters is given in a code, then the digits are greedily assigned to
hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}

\item{icd9Short}{is a character vector of ICD-9 codes. If fewer than
five characters is given in a code, then the digits are greedily assigned
to hundreds, then tens, then units, before the decimal parts. E.g. "10"
becomes "010", not "0010"}
}
\value{
character vector of ICD-9 codes with extra zeroes dropped from major
  part
}
\description{
decimal form ICD-9 codes are not ambiguous if the leading zeroes
  are dropped. Some short-form ICD-9 codes would not be ambiguous, e.g. "1"
  but many would be problematic, so no function is provided to do this for
  short-form codes. This is the inverse of icd9AddLeadingZeroesDecimal
}
\seealso{
Other ICD-9 convert: \code{\link{convert}},
  \code{\link{convert}}, \code{\link{icd9DecimalToParts}},
  \code{\link{icd9DecimalToShort}},
  \code{\link{icd9GetMajor}},
  \code{\link{icd9MajMinToCode}},
  \code{\link{icd9MajMinToDecimal}},
  \code{\link{icd9MajMinToParts}},
  \code{\link{icd9MajMinToShort}},
  \code{\link{icd9PartsToDecimal}},
  \code{\link{icd9PartsToShort}},
  \code{\link{icd9ShortToDecimal}},
  \code{\link{icd9ShortToParts}};
  \code{\link{icd9ChaptersToMap}};
  \code{\link{icd9LongToWide}};
  \code{\link{icd9WideToLong}}
}
\keyword{internal}
\keyword{manip}

