% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getDATRAS.R
\name{getDATRAS}
\alias{getDATRAS}
\title{Get Any DATRAS Data}
\usage{
getDATRAS(record = "HH", survey, years, quarters)
}
\arguments{
\item{record}{the data type required: "HH" haul data, "HL" length-based data, "CA" age-based data.}

\item{survey}{the survey acronym e.g. NS-IBTS.}

\item{years}{a vector of years of the survey, e.g. c(2010, 2012) or 2005:2010.}

\item{quarters}{a vector of quarters of the year the survey took place, i.e. c(1, 4) or 1:4.}
}
\value{
A data frame.
}
\description{
This function combines the functionality of getHHdata, getHLdata, and getCAdata.
It supports querying many years and quarters in one function call.
}
\examples{
hhdata <- getDATRAS(record = "HH", survey = "ROCKALL", years = 2002, quarters = 3)
hldata <- getDATRAS(record = "HL", survey = "ROCKALL", years = 2002, quarters = 3)
cadata <- getDATRAS(record = "CA", survey = "ROCKALL", years = 2002, quarters = 3)

}
\author{
Scott Large and Colin Millar.
}
\seealso{
\code{\link{getHHdata}}, \code{\link{getHLdata}}, and \code{\link{getCAdata}}
get haul data, length-based data, and age-based data.

\code{\link{icesDatras-package}} gives an overview of the package.
}

