% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clean.software.R
\name{clean.software}
\alias{clean.software}
\title{Clean TAF Software}
\usage{
clean.software(folder = "bootstrap/software", quiet = FALSE)
}
\arguments{
\item{folder}{location of local TAF software folder.}

\item{quiet}{whether to suppress messages about removed software.}
}
\description{
Selectively remove software from the local TAF software folder if not listed
in \verb{SOFTWARE.bib}.
}
\note{
For each file in the software folder, the cleaning procedure selects between
three cases:
\enumerate{
\item File and version matches \verb{SOFTWARE.bib} - do nothing.
\item Filename does not contain the version listed in \verb{SOFTWARE.bib} -
      remove.
\item File is not listed in \verb{SOFTWARE.bib} - remove.
}

The \code{taf.bootstrap} procedure cleans the TAF software folder, without
requiring the user to run \code{clean.software}. The main reason for a TAF
user to run \code{clean.software} directly is to experiment with installing
and removing different versions of software without modifying the
\verb{SOFTWARE.bib} file.

The command \code{clean("bootstrap/software")} removes that directory
completely.
}
\seealso{
\code{\link{taf.bootstrap}} calls \code{clean.software} as a part of the
default bootstrap procedure.

\code{\link{clean.library}} cleans the local TAF library.

\code{\link{icesTAF-package}} gives an overview of the package.
}
