test_that("archive functions ok", {
  skip_if_not_installed("arrow")
  skip_if_not_installed("openssl")
  cloud <- ichimoku(sample_ohlc_data)
  df <- xts_df(cloud, keep.attrs = TRUE)
  archive(cloud, filename <- tempfile())
  restored <- archive(filename)
  unlink(filename)
  expect_identical(restored, cloud)
  expect_error(archive(), "is used to")
  expect_error(archive(cloud, cloud, cloud), "Too many arguments")
  expect_error(archive(cloud), "supplied as a string")
  expect_error(archive(cloud, cloud), "supplied as a string")
  expect_error(archive(object = cloud), "specified without")
  filename <- tempfile()
  expect_error(archive(object = sample_ohlc_data, filename = filename), "only works with")
  arrow::write_feather(sample_ohlc_data, filename)
  expect_error(archive(filename = filename), "does not contain")
  unlink(filename)
  dg <- structure(df, ichimoku351 = NA)
  arrow::write_feather(dg, filename <- tempfile())
  expect_message(archive(filename), "cannot be verified")
  unlink(filename)
  dh <- structure(df, ichimoku351 = "010101010101")
  arrow::write_feather(dh, filename <- tempfile())
  expect_warning(archive(filename), "does not match the original")
  unlink(filename)
})
