% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oanda.R
\name{oanda_instruments}
\alias{oanda_instruments}
\title{List Available OANDA Instruments}
\usage{
oanda_instruments(server = c("practice", "live"), apikey)
}
\arguments{
\item{server}{[default "practice"] select either the "practice" or "live" server
depending on the account type held with OANDA.}

\item{apikey}{(optional) string containing the OANDA fxTrade API key (personal
access token), or function that returns this string. Does not need to be
specified if already stored by oanda_set_key(). Can also be entered
interactively if not specified.}
}
\value{
A data.frame containing the instrument name, type, and full display name.
}
\description{
Return list of instruments including major currencies, metals, commodities,
    government bonds and stock indices for which pricing data is available
    from the OANDA fxTrade API.
}
\details{
This function returns a data.frame listing the instrument names
    available for an account associated with the supplied OANDA fxTrade API key.

    For further details please refer to the OANDA fxTrade API vignette by
    running: \code{vignette("xoanda", package = "ichimoku")}.
}
\examples{
\dontrun{
# OANDA fxTrade API key required to run this example
oanda_instruments()
}

}
