% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mltools.R
\name{autostrat}
\alias{autostrat}
\title{Automated Ichimoku Strategies}
\usage{
autostrat(x, n = 8, dir = c("long", "short"), level = 1, quietly)
}
\arguments{
\item{x}{an ichimoku object.}

\item{n}{[default 8] select top 'n' number of strategies to return.}

\item{dir}{[default 'long'] trade direction, either 'long' or 'short'.}

\item{level}{[default 1] to return simple strategies. For complex strategies,
set level to 2 to return combined strategies of the form 's1 & s2' or
level to 3 to return asymmetric strategies of the form 's1 x s2'.}

\item{quietly}{(optional) if set to TRUE, will suppress printing of additional
output to the console and return quietly.}
}
\value{
Returned invisibly, a list of 'n' ichimoku objects containing
    strategies, with attributes 'logret' (a vector of cumulative log returns
    for all strategies) and 'summary' (a matrix of summaries for the top 'n'
    strategies).

    In addition, the strategy summaries are printed to the console.
}
\description{
Generate a list of the top performing ichimoku cloud strategies based on
    simple indicator conditions of the form 'c1 > c2' (level 1), complex
    combined strategies of the form 'c1 > c2 & c3 > c4' (level 2), or complex
    asymmetric strategies of the form 'c1 > c2 x c3 > c4' (level 3).
}
\details{
Ichimoku objects for each strategy are returned as a list. The
    cumulative log returns for all strategies as well as the summaries for
    the top 'n' strategies are saved as attributes to the list. This
    information may be retrieved by using \code{\link{look}} on the returned
    list.

    Each individual ichimoku object may be accessed via its position in the
    list, e.g. [[1]] for the 1st item, or by using \code{\link{look}}
    specifying the parameter 'which'.
}
\section{Further Details}{

    Please refer to the strategies vignette by calling:
    \code{vignette("strategies", package = "ichimoku")}
}

\examples{
cloud <- ichimoku(sample_ohlc_data, ticker = "TKR")

stratlist <- autostrat(cloud, n = 3, quietly = TRUE)
look(stratlist)
strat <- look(stratlist, which = 1)
summary(strat)

autostrat(cloud, n = 1, dir = "short", level = 2)
autostrat(cloud, n = 1, dir = "long", level = 3)

}
