% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-spherical.R
\name{arcdistmat}
\alias{arcdistmat}
\title{Calculation of distance matrices along arcs}
\usage{
arcdistmat(
  points1,
  points2 = NULL,
  origin = c(0, 0, 0),
  output = "distance",
  radius = authRadius
)
}
\arguments{
\item{points1}{(\code{numeric}) Matrix, XYZ or longitude-latitude coordinates of the first set of points.}

\item{points2}{(\code{numeric}) Matrix, XYZ or longitude-latitude coordinates of the second set of points. 
Leave this empty if you want all the arc distances between a set of points}

\item{origin}{(\code{numeric}) Vector, the center of the circle in XYZ coordinates (default is \code{c(0,0,0)}).}

\item{output}{(\code{character}) The type of the output value. \code{"distance"} will give back the distance
in the metric that was fed to the function in the coordinates or the radius.
\code{"deg"} will output the the distance in degrees, \code{"rad"} will do
so in radians.}

\item{radius}{(\code{numeric}) The radius of the circle in case the input points have polar coordinates only.
Unused when XYZ coordinates are entered. Defaults to the authalic radius of Earth ca. 6371.007km.}
}
\value{
A single \code{numeric} value.
}
\description{
This function calculates the shortest arc distance matrix between two sets of points.
}
\details{
This function will create all possible shortest arc distances between points in the two sets,
	but not between the points within the sets. The function is useful for great circle distance calculations.
	For a symmetrical distance matrix leave the \code{points2} argument empty.
}
\examples{
g <- trigrid(c(4))
res <- arcdistmat(g@vertices)

rand<-rpsphere(500)
res2 <- arcdistmat(g@vertices, rand)

}
