% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-graphs.R, R/data-facelayer-graphs.R
\name{gridgraph}
\alias{gridgraph}
\alias{gridgraph,trigrid-method}
\alias{gridgraph,hexagrid-method}
\alias{gridgraph,facelayer-method}
\title{Create or instantiate an \code{\link[igraph:make_graph]{graph}} class graph from the faces of an icosahedral grid}
\usage{
gridgraph(x, ...)

\S4method{gridgraph}{trigrid}(x, directed = FALSE, distances = FALSE)

\S4method{gridgraph}{hexagrid}(x, directed = FALSE, distances = FALSE)

\S4method{gridgraph}{facelayer}(x)
}
\arguments{
\item{x}{(\code{\link{trigrid}}, \code{\link{hexagrid}} or \code{\link{facelayer}}) The icosahedral grid or \code{\link{facelayer}}.}

\item{...}{Arguments passed to the class specific methods.}

\item{directed}{\code{logical} Defaults to \code{FALSE}, creating an undirected graph. If \code{TRUE}, then the graph will be directed.}

\item{distances}{\code{logical} Defaults to \code{FALSE}. If \code{TRUE}, then the distances between the linked faces will be calculated and will be rendered to the edges as \code{"dist"}.}
}
\value{
The function returns an undirected igraph graph.
}
\description{
The function can be applied to both grids and to \code{\link{facelayer}}-class object of \code{logical} values. The resulting graph will have the characteristics of the original grid (directed/undirected etc.).
}
