% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid-lookup.R
\name{locate}
\alias{locate}
\alias{locate,trigrid,matrix-method}
\alias{locate,trigrid,numeric-method}
\alias{locate,trigrid,data.frame-method}
\alias{locate,trigrid,sf-method}
\alias{locate,trigrid,SpatialPoints-method}
\alias{locate,trigrid,SpatialPointsDataFrame-method}
\alias{locate,hexagrid,matrix-method}
\title{Basic lookup function of coordinates on an icosahedral grid}
\usage{
locate(x, y, ...)

\S4method{locate}{trigrid,matrix}(x, y, randomborder = FALSE, output = "ui")

\S4method{locate}{trigrid,numeric}(x, y, ...)

\S4method{locate}{trigrid,data.frame}(x, y, ...)

\S4method{locate}{trigrid,sf}(x, y, ...)

\S4method{locate}{trigrid,SpatialPoints}(x, y, ...)

\S4method{locate}{trigrid,SpatialPointsDataFrame}(x, y, ...)

\S4method{locate}{hexagrid,matrix}(x, y, output = "ui", randomborder = FALSE, forceNA = FALSE)
}
\arguments{
\item{x}{(\code{trigrid}, \code{hexagrid}) Icosahedral grid object.}

\item{y}{(\code{matrix}, \code{data.frame}, \code{numeric} or \code{Spatial}) Coordinates of individual points. Can be either a two-dimensional 
matrix of long-lat coordinates, a three-dimensional matrix of XYZ coordinates, 
or a set of points with class \code{\link[sp]{SpatialPoints}} or \code{\link[sp:SpatialPoints]{SpatialPointsDataFrame}}.}

\item{...}{Arguments passed to class specific methods.}

\item{randomborder}{(\code{logical}) Defaults to \code{FALSE}. If \code{TRUE}, then the points
falling on vertices and edges will be randomly assigned, otherwise they will be kept as \code{NA}s.}

\item{output}{(\code{character}) Either \code{"ui"} or \code{"skeleton"}. \code{"ui"} returns the face 
names used in the user interface, while \code{"skeleton"} returns their 
indices used in back-end procedures.}

\item{forceNA}{(\code{logical}) Suppressing the recursive lookup of points falling on subface boundaries.}
}
\value{
The function returns the cell names (as \code{character}) where the input coordinates fall.
}
\description{
Basic lookup function of coordinates on an icosahedral grid
}
\examples{
# create a grid 
g <- trigrid(4)
# some random points
randomPoints<-rpsphere(4, output="polar")
# cells
locate(g, randomPoints)
}
