% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\docType{methods}
\name{plot3d,facelayer-method}
\alias{plot3d,facelayer-method}
\title{3d plotting of a facelayer of an icosahedral grid or its subset}
\usage{
\S4method{plot3d}{facelayer}(x, type = "f", frame = TRUE, guides = TRUE,
  defaultPar3d = TRUE, ...)
}
\arguments{
\item{x}{The \code{facelayer} object to be plotted.}

\item{type}{A character value specifying the part of the grid to be plotted by the call of the function. 
\code{"l"} plots the grid lines (only when frame=FALSE). 
\code{"f"} draws the grid faces.
\code{FALSE} does not plot the sphere.}

\item{frame}{If set to TRUE the grid line structure will be plotted.}

\item{guides}{If set to TRUE the guides3d() function will be run with col="green" and default settings.}

\item{defaultPar3d}{Logical value, whether the default settings for par3d() are to be used (windowRect = c(50, 60, 800, 800), zoom=0.8).}

\item{...}{Further graphical parameters passed to (see \code{\link[rgl]{plot3d}}).}
}
\description{
The function is built on the openGL renderer of the R package \code{rgl}. The default plotting window size is 800x800 pixels. In case you want to override this, please
use the function with 'defaultPar3d=FALSE' after running 'rgl::par3d(windowRect=<>)'.
}

