% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compare_to_normal.R
\name{hist_compare_to_normal}
\alias{hist_compare_to_normal}
\title{hist_compare_to_normal}
\usage{
hist_compare_to_normal(
  x,
  col = "lightgray",
  main = "",
  xlab = "",
  ylab = "",
  lwd_line = 1.5,
  col_line1 = "#ff160e",
  col_line2 = "#335bff",
  add_legend = TRUE,
  legend_position = "topleft",
  delta = 0.2,
  ...
)
}
\arguments{
\item{x}{data vector to be visualized.}

\item{col}{color of the histogram.}

\item{main}{string indicating the title of the plot.}

\item{xlab}{a string indicating the x label.}

\item{ylab}{a string indicating the y label.}

\item{lwd_line}{width of density lines.}

\item{col_line1}{color of density line classic mle estimation.}

\item{col_line2}{color of density line classic robust estimation.}

\item{add_legend}{a Boolean if the estimated parameters of the Normal distribution should be plotted.}

\item{legend_position}{a string specifying the position of the legend.}

\item{delta}{graphic parameter to determine the shrinkage of the axis.}

\item{...}{Extra graphical arguments.}
}
\value{
No return value. Plot a histogram.
}
\description{
hist_compare_to_normal
}
\examples{
n <- 1000
x <- rnorm(n = n)
hist_compare_to_normal(x)
x2 <- rexp(n, rate = 25)
hist_compare_to_normal(x2, legend_position = "topright")
}
