# Overview
Welcome to the IDEA Data Center's (IDC's) Nonresponse Bias Analysis Application, or *NRBA App*, an
interactive application that you can use to analyze survey data response rates, representativeness, and
nonresponse bias.

Use the *NRBA App* to answer questions such as
- What are our response rates, and do they differ across subgroups?
- Are some subgroups in the population overrepresented or underrepresented in our respondent
data?
- How do survey outcomes differ across subgroups?
- Can statistical adjustments reduce nonresponse bias in our data?

The tool consists of three modules--Setup, Analysis, and Report. Before using the *NRBA App*, IDC highly
recommends that states leverage the technical assistance IDC provides to make the most of this tool.
Contact your IDC State Liaison or email IDEAdata@westat.com to connect with a TA specialist. The
sections below provide a broad overview of the functionality of each module.

### Setup: Load a Prepared Dataset into the Application

First, select and import a dataset to use for analysis (Step 1: Import). IDC recommends that your dataset
has certain elements to ensure optimal use of the *NRBA App*. Refer to the Preparing Your Dataset section
of the *NRBA App User's Guide* for more information and a list of these elements. Once you have imported
your dataset, the app will provide a summary of the contents of the dataset along with a preview of the
first few rows and columns of the dataset.

Next, to properly analyze the data, indicate how you collected the data (Step 2: Identify the Data
Collection Method). This includes identifying whether the data come from an attempted census or
represent a survey sample, which variable indicates response and eligibility status for the survey, and
other variables in the data related to the method of data collection. Once you have described the data in
the Setup module, you can move to the Analysis module.

Note: The app will check for errors in the Setup options that you selected before proceeding.


### Analysis: Select and Configure Specific Analyses to Run, and View the Results

This module allows you to select from a variety of analysis types to answer questions about response
rate, representativeness, and nonresponse bias. When you select an analysis type from the menu, a new
Specify Analysis tab will appear with options for conducting the specific analysis. The application will
recommend some of these selections as defaults. When you submit your options, a pop-up window will
appear, showing a table with the resulting statistics for the analysis.

Once complete, you can add the analysis output to the Report module. You can then repeat the same
analysis with a variety of options (e.g., calculating response rates separately by race, disability category,
or other demographic variable) or select a different analysis type and then add each type of analysis to
the report module.

Once you have finished adding your analyses, you can move to the Report module.

### Report: Export Output Tables Summarizing the Analyses to an Excel File

When you open the Report module, a list of the analyses you've added to the report will appear in the
Items in Report display at the top. From this display, you can remove any output tables you no longer
want and save the report by clicking Save to Excel.

Note: The application does not save the information you enter during each session. The next time
you launch the *NRBA App* to begin a new session, you will need to complete the Setup module again for
that new session.

# For Help with the App

You are accessing the point-and-click interface of this tool through your web browser and running it
using the open-source data analysis program, RStudio. Please note that this tool is not 508 accessible.

As you use the *NRBA App*, be aware of additional instructions and help available within it. For example,
each module of the *NRBA App* includes written instructions that cover the steps outlined above. In
addition, built-in screen tips provide more information and definitions of key terms. You can access these
tips by hovering over the text within the app.

For more detailed information on using the *NRBA App*, including preparing and importing your dataset,
understanding the statistical processes behind each analysis option, and interpreting the results of
analyses, refer to the *NRBA App User's Guide* available from the Resources dropdown menu on this
webpage. For individualized technical assistance using this tool, please contact your IDC State Liaison or
email IDEAdata@westat.com.

If you are ready to begin using this tool, move to the Setup tab.

DISCLAIMER:

The IDEA Data Center (IDC) created this publication under U.S. Department of Education, Office of
Special Education Programs Grant No. H373Y190001. Richelle Davis and Rebecca Smith serve as the
project officers.

The views expressed herein do not necessarily represent the positions or policies of the U.S. Department
of Education. No official endorsement by the U.S. Department of Education of any product, commodity,
service, or enterprise mentioned in this publication is intended or should be inferred. This product is in
the public domain. Authorization to reproduce it in whole or in part is granted.
Westat is the lead organization for IDC. For more information about the center's work and its partners,
see [www.ideadata.org](https://www.ideadata.org).

July 2023

**Suggested Citation**:
Schneider, B., Nimkoff, T., Fucci, A., Cruse, A., Cates, A., and Green, J. (2023, July). *NRBA App*. IDEA Data
Center. Rockville, MD: Westat.
