% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/idem_package.R
\docType{package}
\name{idem-package}
\alias{idem-package}
\alias{idem}
\title{Inference in Randomized Clinical Trials with Death and Missingness}
\description{
This package contains the functions for drawing inference in randomized
clinical trials with death and intermittent missingness.
}
\section{Notation}{


Consider a two-arm randomized study. Let \eqn{Y_k} denote outcome measured at
time \eqn{t_k} and \eqn{Z} denote a functional endpoint that is a function of
\eqn{Y}. Let \eqn{L} denote the survival time. Let \eqn{X} denote the
baseline covariates and \eqn{T} denote the treatment assignment.
}

\section{Ranking}{


If two subject were both alive at the end of the study, they are ranked based
on functional outcome \eqn{Z}. If at least one subject was dead at the end of
the study, they are ranked based on survival time \eqn{L}.

Treatment effect, \eqn{\theta} is defined as the probability that the outcome
for a random individual randomized to treatment \eqn{T=0} is less than the
outcome of a random individual randomized to treatment \eqn{T=1} minus the
probability that the outcome for a random individual randomized to treatment
\eqn{T=0} is greater than the outcome of a random individual randomized to treatment
\eqn{T=1}.
}

\section{Missingness}{


In order to estimate \eqn{\theta} in the presence of missing data, we need to
impute \eqn{Z} for subjects alive at the end of the study with \eqn{Y_k} missing
for some \eqn{k}.

The benchmark assumption we consider for the imputation is the complete case
missing value (CCMV) restrictions. We then consider exponential tilting
models for introducing sensitivity parameters for evaluating the robustness
of the findings with regards to different missing data mechanism assumptions.
The models are as follows:

\deqn{ f(Y^{(s)}_{mis} | Y^{(s)}_{obs}, Y_0, X, T,S=s) \propto \exp(
\beta_T Z) f(Y^{(s)}_{mis} | Y^{(s)}_{obs}, Y_0, X, T,S=1)
}

where \eqn{S} denotes the missingness patterns, \eqn{S=1} denotes the
completers and \eqn{\beta_T} denotes the sensitivity parameter for arm \eqn{T}.
}

\section{Graphical user interface (GUI)}{


This package provides a web-based GUI. See \code{\link{imShiny}} for
details.
}

\references{
Wang C, Scharfstein DO, Colantuoni E, Girard T, Yan Y (2016). Inference in
Randomized Trials with Death and Missingness. <DOI:10.1111/biom.12594>

Wang C, Colantuoni E, Leroux A, Scharfstein DO (2020). idem: An R Package for
Inferences in Clinical Trials with Death and Missingness.
<DOI:10.18637/jss.v093.i12>
}
