% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_strat_model_output.R
\name{combine_strat_model_output}
\alias{combine_strat_model_output}
\title{Reduces the Dimensionality of a Stratified Model}
\usage{
combine_strat_model_output(df, strat = NULL, compartments = NULL,
  hold_out_var = NULL)
}
\arguments{
\item{df}{A data frame with variables stratified using numeric labels.}

\item{strat}{An integer specifying the number of stratifications to reduce.}

\item{compartments}{A character vector specifying the unique population compartments.}

\item{hold_out_var}{A character vector specifying the variables to keep unchanged. Defaults to NULL}
}
\value{
A dataframe of model output that has its dimensionality reduced
}
\description{
Reduces the dimensions of stratified model output. Default behaviour is to remove stratification for all
variables. However, variables to reduce the dimensions of can be selected, as can variables to preserve with there structure intact.
}
\examples{

df <- data.frame(S1 = NA, S2 = NA, S3 = NA, time = NA)
combine_strat_model_output(df, 3, compartments = "S", hold_out_var = "time")

}
\seealso{
combine_to_age_model
}
