% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gather_strat_multi_variable.R
\name{gather_strat_multi_variable}
\alias{gather_strat_multi_variable}
\title{A Function to Gather Multiple Stratified Variables into a Tidy Format}
\usage{
gather_strat_multi_variable(
  df,
  id_col,
  compartments = NULL,
  hold_out_var = NULL,
  strat = NULL,
  groups = NULL
)
}
\arguments{
\item{df}{A data frame with variables stratified using numeric labels.}

\item{id_col}{A character string containing the name of the new id column.}

\item{compartments}{A character vector specifying the unique population compartments.}

\item{hold_out_var}{A character vector specifying the variables to keep unchanged. Defaults to NULL}

\item{strat}{An integer specifying the number of stratifications to reduce.}

\item{groups}{A character vector with length equal to the level of stratification.
Used to name the stratified levels.}
}
\value{
A dataframe of stratified model output with multiple Tidy variables.
}
\description{
A Function to Gather Multiple Stratified Variables into a Tidy Format
}
\examples{


df <- data.frame(time = 0, A1 = 1, A2 = 2, A3 = 3, B1 = 2, B2 = 3, B3 = 0)
gather_strat_multi_variable(df, id_col = "Age", compartment = c("A", "B"), hold_out_var = "time",
                            strat = 3, groups = c("Children", "Young adults", "Adults"))

}
