% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHLIR.R
\name{SHLIR_ode}
\alias{SHLIR_ode}
\title{Susceptible-High-risk-latent-Low-risk-latent-Infected-Recovered Model}
\usage{
SHLIR_ode(t, x, params)
}
\arguments{
\item{t}{The timestep over which to calculate derivatives}

\item{x}{A numeric vector of compartment populations.}

\item{params}{A named vector of parameter values.}
}
\value{
A vector of derivatives
}
\description{
Susceptible-High-risk-latent-Low-risk-latent-Infected-Recovered Model
}
\examples{
##Model Input
S_0 <- 989
H_0 <- 10
L_0 <- 0
I_0 <- 1
R_0 <- 0
beta = 3 # Rate of transmission
gamma_H = 1/5 # Rate of progression to active symptoms from high risk latent
nu = 1/2 #Rate of progression from high to low risk latent
gamma_L = 1/100 # Rate of progression to active symptoms for low risk latent
tau = 1/2 # Rate of recovery

parameters <- c(beta = beta, gamma_H = gamma_H, gamma_L = gamma_L, nu = nu, tau = tau)
inits <- c(S = S_0, H = H_0, L = L_0, I = I_0, R_0 = R_0)

SHLIR_ode(1, inits, parameters)
}
