% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FgivenA.R
\encoding{UTF-8}
\name{FgivenA}
\alias{FgivenA}
\alias{FgivenA}
\alias{FA}
\title{Future value given Annual value (Engineering Economics)}
\usage{
FgivenA(A, n, i, frequency = c("annual", "semiannual", "quarter", "bimonth",
  "month", "daily"))

FA(A, n, i, frequency = c("annual", "semiannual", "quarter", "bimonth",
  "month", "daily"))
}
\arguments{
\item{A}{numeric vector that contains the annual value(s)}

\item{n}{numeric vector that contains the period value(s)}

\item{i}{numeric vector that contains the interest rate(s) as a percent}

\item{frequency}{character vector that contains the frequency used to
obtain the number of periods [annual (1), semiannual (2), quarter (4),
bimonth (6), month (12), daily (365)]}
}
\value{
FgivenA numeric vector that contains the future value(s) rounded to
   2 decimal places

FA data.frame of both n (0 to n) and the resulting future values
   rounded to 2 decimal places
}
\description{
Compute F given A
}
\details{
F is expressed as

\deqn{F = A\left[\frac{\left(1 + i\right)^n - 1}{i}\right]}

\describe{
\item{\emph{F}}{the "future equivalent"}
\item{\emph{A}}{the "uniform series amount (occurs at the end of each
    interest period)"}
\item{\emph{i}}{the "effective interest rate per interest period"}
\item{\emph{n}}{the "number of interest periods"}
}
}
\examples{
library(iemisc)
# Example 4-7 from the Reference text (page 131-132)
FgivenA(23000, 40, 6, "annual") # the interest rate is 6\%

FA(23000, 40, 6, "annual") # the interest rate is 6\%


}
\references{
William G. Sullivan, Elin M. Wicks, and C. Patrick Koelling, \emph{Engineering Economy}, Fourteenth Edition, Upper Saddle River, New Jersey: Pearson/Prentice Hall, 2009, page 131-132, 142, 164.
}
