% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cosd.R
\encoding{UTF-8}
\name{cosd}
\alias{cosd}
\title{Cosine (in degrees) [GNU Octave/MATLAB compatible]}
\source{
\enumerate{
   \item r - How to not run an example using roxygen2? - Stack Overflow answered and edited by samkart on Jul 9 2017. (Also see the additional comments in response to the answer.) See \url{https://stackoverflow.com/questions/12038160/how-to-not-run-an-example-using-roxygen2}.
   \item devtools - Issues in R package after CRAN asked to replace dontrun by donttest - Stack Overflow answered by Hong Ooi on Sep 1 2020. (Also see the additional comments in response to the answer.) See \url{https://stackoverflow.com/questions/63693563/issues-in-r-package-after-cran-asked-to-replace-dontrun-by-donttest}.
}
}
\usage{
cosd(x)
}
\arguments{
\item{x}{A numeric vector containing values in degrees}
}
\value{
The cosine of each element of \code{x} in degrees. Zero for any
'elements where (\code{x} - 90) / 180 is an integer.'
}
\description{
Calculates the value of cosine for each element of \code{x} in degrees in a
manner compatible with GNU Octave/MATLAB. Zero is returned for any 'elements
where (\code{x} - 90) / 180 is an integer.' Reference: Eaton.
}
\note{
Note: If you have a radian (rad) angle value, use \code{\link[base]{cos}} instead.
}
\examples{

library(iemisc)

# Example from GNU Octave cosd

cosd(seq(0, 80, by = 10))


\donttest{
# See Source 1 and Source 2

library(iemisc)

try(cosd("90"))
}




}
\references{
\enumerate{
   \item John W. Eaton, David Bateman, Søren Hauberg, and Rik Wehbring (November 2022). \emph{GNU Octave: A high-level interactive language for numerical computations: Edition 7 for Octave version 7.3.0}. \url{https://docs.octave.org/octave.pdf}. Page 553.
   \item Wikimedia Foundation, Inc. Wikipedia, 24 February 2019, "Radian", \url{https://en.wikipedia.org/wiki/Radian}.
}
}
\author{
David Bateman (GNU Octave cosd), Irucka Embry
}
