% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{ihpd_get}
\alias{ihpd_get}
\title{Download International House Price Database Data}
\usage{
ihpd_get(symbol = c("raw", "gsadf", "bsadf"))
}
\arguments{
\item{symbol}{which dataset to download.}
}
\description{
Available downloads:
\enumerate{
\item raw: Raw Data
\item gsadf: Generalized sup ADF statistics
\item bsadf: Backward sup ADF statistic sequence
}
}
\details{
\describe{
\item{raw}{

Includes the following time series for the countries covered:
\itemize{
\item hpi: The house price index.
\item rhpi: The house price index expressed in real terms.
\item pdi: The personal disposable income index.
\item rpdi: The personal disposable income expressed in real terms index.
}
All variables in real terms are deflated with the personal consumption
expenditure (PCE) deflator.}
}

The exuberance indicators include
\describe{
\item{gsadf}{
\itemize{
\item type: real house price index (rhpi) and the ratio of rhpi to real
personal disposable income (rpdi)
\item lag: lag length of 1 and 4
\item sig: significance level for the critical value
\item value: test statistics for explosive behavior
\item crit: 95 percent critical values.
}
}

\item{bsadf}{
The exuberance indicators include
\itemize{
\item type: real house price index (rhpi) and the ratio of rhpi to real
personal disposable income (rpdi)
\item lag: lag length of 1 and 4,
\item value: test statistics for explosive behavior
\item crit: 95 percent critical values.
}
}
}
}
\examples{

ihpd_get()
}
