% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imPoisC.R, R/imPoisM.R, R/imZTPoisM.R
\name{cpm}
\alias{cpm}
\alias{cpm1}
\alias{dcpm}
\alias{dmpm}
\alias{dmpm.ztrunc}
\alias{em.pdf}
\alias{em.pdf.ztrunc}
\alias{em.rt}
\alias{em.rt.ztrunc}
\alias{et.la}
\alias{et.pdf}
\alias{et.rt}
\alias{et0.pdf}
\alias{et2.pdf}
\alias{ey}
\alias{mpm}
\alias{mpm.ztrunc}
\alias{mpm1}
\alias{mpm1.ztrunc}
\alias{pcpm}
\title{Conjugate Prior Measure}
\usage{
cpm(t, xi2, xi1, xi0, log = FALSE)

cpm1(t, xi2, xi1, xi0, log = FALSE)

dcpm(x, pars, log.p = FALSE)

pcpm(q, pars, lower.tail = TRUE, log.p = FALSE)

et.pdf(y = NULL, pars)

ey(y = NULL, pars)

et.rt(y = NULL, pars)

et.la(y = NULL, pars, const = 1000)

et2.pdf(y = NULL, pars)

et0.pdf(y = NULL, pars)

mpm(m, xi2, xi1, xi0, log = FALSE)

mpm1(m, xi2, xi1, xi0, log = FALSE)

dmpm(x, pars, log.p = FALSE)

em.pdf(y = NULL, pars)

em.rt(y = NULL, pars)

mpm.ztrunc(m, xi2, xi1, xi0, log = FALSE)

mpm1.ztrunc(m, xi2, xi1, xi0, log = FALSE)

dmpm.ztrunc(x, pars, log.p = FALSE)

em.pdf.ztrunc(y = NULL, pars)

em.rt.ztrunc(y = NULL, pars)
}
\arguments{
\item{t}{variable}

\item{xi2}{precision}

\item{xi1}{linear component}

\item{xi0}{effective sample size}

\item{log}{logical}

\item{x}{quantile}

\item{pars}{parameters of length 3}

\item{log.p}{logical; if TRUE, probabilities \eqn{p} are given as \eqn{log(p)}}

\item{q}{quantiles}

\item{lower.tail}{logical; if TRUE, probabilities are \eqn{P[X\le x]} otherwise, \eqn{P[X>x]}}

\item{y}{a vector of observations, by default, NULL}

\item{const}{constant}

\item{m}{mean parameter}
}
\description{
A conjugate prior measure on the canonical parameter is defined in the form of three-parameter exponenitial family of probability measure.  \code{cpm1} computes a normalizing constant.   \code{dcpm} and \code{pcpm} give density and distribution functions for the canonical variable \code{t}.  Also see the \sQuote{Details}.
}
\details{
A formal definition of this conjugate prior measure is given by
\deqn{e^(-\xi_2\theta^2 + \xi_1\theta - \xi_0\exp(\theta))},
where \eqn{\theta} is a canonical variable ranged from \code{-Inf} to \code{Inf}, \eqn{\xi_2} is a precision parameter, \eqn{\xi_1} is a linear component, and \eqn{\xi_0} is an effective sample size.
}
\author{
Chel Hee Lee \email{chl948@mail.usask.ca}
}
\references{
Lee, C.H. (2014) Imprecise Prior for Imprecise Inference on Poisson Sampling Models, PhD Thesis, University of Saskatchewan
}

