% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/imbalance.R
\name{oversample}
\alias{oversample}
\title{Wrapper that encapsulates a collection of algorithms to perform a class
balancing preprocessing task for binary class datasets}
\usage{
oversample(dataset, ratio = NA, method = c("RACOG", "wRACOG", "PDFOS",
  "RWO", "ADASYN", "ANSMOTE", "SMOTE", "MWMOTE", "BLSMOTE", "DBSMOTE", "SLMOTE",
  "RSLSMOTE"), filtering = FALSE, classAttr = "Class", wrapper = c("KNN",
  "C5.0"), ...)
}
\arguments{
\item{dataset}{A binary class \code{data.frame} to balance.}

\item{ratio}{Number between 0 and 1 indicating the desired ratio between
minority examples and majority ones, that is, the quotient {size of
minority class}/{size of majority class}. There are methods, such as
\code{ADASYN} or \code{wRACOG} to which this parameter does not apply.}

\item{method}{A \code{character} corresponding to method to apply. Possible
methods are: RACOG, wRACOG, PDFOS, RWO, ADASYN, ANSMOTE, BLSMOTE, DBSMOTE,
BLSMOTE, DBSMOTE, SLMOTE, RSLSMOTE}

\item{filtering}{Logical (TRUE or FALSE) indicating wheter to apply filtering
of oversampled instances with \code{\link{neater}} algorithm.}

\item{classAttr}{\code{character}. Indicates the class attribute from \code{dataset}.
Must exist in it.}

\item{wrapper}{A \code{character} corresponding to wrapper to apply if
selected method is \code{\link{wracog}}. Possibilities are: \code{"C5.0"}
and \code{"KNN"}.}

\item{...}{Further arguments to apply in selected method}
}
\value{
A balanced \code{data.frame} with same structure as \code{dataset},
  containing both original instances and new ones
}
\description{
Wrapper that encapsulates a collection of algorithms to perform a class
balancing preprocessing task for binary class datasets
}
\examples{
data(glass0)

# Oversample glass0 to get an imbalance ratio of 0.8
imbalanceRatio(glass0)
# 0.4861111
newDataset <- oversample(glass0, ratio = 0.8, method = "MWMOTE")
imbalanceRatio(newDataset)
newDataset <- oversample(glass0, method = "ADASYN")
newDataset <- oversample(glass0, ratio = 0.8, method = "SMOTE")

}
