% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/singlecell.R
\name{select_barcodes}
\alias{select_barcodes}
\title{Select specific clonotypes using barcodes from single-cell metadata}
\usage{
select_barcodes(.data, .barcodes, .force.list = FALSE)
}
\arguments{
\item{.data}{The data to be processed. Can be \link{data.frame},
\link{data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format.
\link{immunarch_data_format}

Competent users may provide advanced data representations:
DBI database connections, Apache Spark DataFrame from \link{copy_to} or a list
of these objects. They are supported with the same limitations as basic objects.

Note: each connection must represent a separate repertoire.}

\item{.barcodes}{Either a character vector with barcodes or a named character/factor vector with
barcodes as names and cluster IDs a vector elements. The output of Seurat's \code{Idents} function works.}

\item{.force.list}{Logical. If TRUE then always return a list, even if the result is one data frame.}
}
\value{
An immune repertoire (if ".barcodes" is a barcode vector) or a list of immune repertoires
(if ".barcodes" is named vector or an output from Seurat::Idents()). Each element is an immune repertoire
with clonotype barcodes corresponding to the input barcodes. The output list's names are cluster names
in the ".barcode" argument (Seurat::Idents() case only).
}
\description{
Subset the input immune repertoire by barcodes. Pass a vector of
barcodes to subset or a vector cluster IDs and corresponding barcodes to
get a list of immune repertoires corresponding to cluster IDs.
Columns with clonotype counts
and proportions are changed accordingly to the filtered barcodes.
}
\examples{
\dontrun{
data(immdata)
# Create a fake single-cell data
df <- immdata$data[[1]]
df$Barcode <- "AAAAACCCCC"
df$Barcode[51:nrow(df)] <- "GGGGGCCCCC"
barcodes <- "AAAAACCCCC"
df <- select_barcodes(df, barcodes)
nrow(df)
}
}
\seealso{
\link{select_clusters}
}
\concept{single_cell}
