% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seqCluster.R
\name{seqCluster}
\alias{seqCluster}
\title{Function for asignment clusters based on sequencies similarity}
\usage{
seqCluster(.data, .dist, .perc_similarity, .nt_similarity, .fixed_threshold)
}
\arguments{
\item{.data}{The data which was used to caluculate .dist object. Can be \link{data.frame},
\link{data.table}, or a list of these objects.

Every object must have columns in the immunarch compatible format \link{immunarch_data_format}}

\item{.dist}{List of distance objects produced with \link{seqDist} function.}

\item{.perc_similarity}{Numeric value between 0-1  specifying the maximum acceptable weight of an edge in a graph.
This threshold depends on the length of sequences.}

\item{.nt_similarity}{Numeric between 0-sequence length specifying
the threshold of allowing a 1 in n nucleotides mismatch in sequencies.}

\item{.fixed_threshold}{Numeric specifying the threshold on the maximum weight of an edge in a graph.}
}
\value{
Immdata data format object. Same as .data, but with extra 'Cluster' column with clusters assigned.
}
\description{
Graph clustering based on distances between sequences
}
\examples{

data(immdata)
# In this example, we will use only 2 samples with 500 clonotypes in each for time saving
input_data <- lapply(immdata$data[1:2], head, 500)
dist_result <- seqDist(input_data)
cluster_result <- seqCluster(input_data, dist_result, .fixed_threshold = 1)
}
