% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HLA_prefix_remove.R
\name{HLA_prefix_remove}
\alias{HLA_prefix_remove}
\title{HLA_prefix_remove}
\usage{
HLA_prefix_remove(data, keep_locus = FALSE)
}
\arguments{
\item{data}{A string with a single HLA allele, a GL string of HLA alleles,
or a character vector containing either of the previous.}

\item{keep_locus}{A logical value indicating whether to retain any locus values.
The default value is FALSE.}
}
\value{
A vector modified to remove HLA and optionally locus prefixes.
}
\description{
This function removes HLA and optionally locus prefixes from a string of HLA typing:
"HLA-A2" changes to "A2" or "2". By default, HLA and locus prefixes are removed. This function
also works on each allele in a GL string.
}
\examples{
# The HLA_typing_1 dataset contains a table with HLA typing spread across multiple columns:
print(HLA_typing_1)

# The `HLA_prefix_remove` function can be used to get each column to have only the
# colon-separated fields:
library(dplyr)
HLA_typing_1 \%>\% mutate(
  across(
    A1:DPB1_2,
    ~ HLA_prefix_remove(.)
  )
)

}
