% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.imptree}
\alias{print.imptree}
\title{Classification with Imprecise Probabilities}
\usage{
\method{print}{imptree}(x, digits = getOption("digits"), sep = "\\t",
  ...)
}
\arguments{
\item{x}{Object of class \code{imptree}. See details.}

\item{digits}{a non-null value for digits specifies the minimum number
of significant digits to be printed in values. The default uses 
\code{\link[base]{getOption}("digits")}. Non-integer values will be rounded down,
and only values greater than or equal to 1 and 
no greater than 17 are accepted.}

\item{sep}{Separator between the displayed IPDistribution objects.
(Default: \code{'\t'})}

\item{\dots}{Additional arguments; ignored at the moment}
}
\value{
Returns the calling object invisible.
}
\description{
Printing the \code{imptree} object to console
}
\details{
An existence check on the stored C++ object reference is carried out 
at first. If the reference is not valid the original call
for \code{"object"} is printed as error.

For a more detailed summary of the tree \code{\link{summary.imptree}}.
}
\examples{
data("carEvaluation")

## create a tree with IDM (s=1) to full size
## carEvaluation, leaving the first 10 observations out
ip <- imptree(acceptance~., data = carEvaluation[-(1:10),], 
  method="IDM", method.param = list(splitmetric = "globalmax", s = 1), 
  control = list(depth = NULL, minbucket = 1))

ip                        ## standard printing; same as 'print(ip)'
print(ip, sep = ";")      ## probability intervals are separated by ';'

}
\seealso{
\code{\link{imptree}}, \code{\link{summary.imptree}}
}
\author{
Paul Fink \email{Paul.Fink@stat.uni-muenchen.de}
}
\keyword{tree}
