% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/funs.R
\name{plotIm}
\alias{plotIm}
\title{Plot function for imputation}
\usage{
plotIm(imp, mis, true, ...)
}
\arguments{
\item{imp}{the imputed data matrix}

\item{mis}{the missing data matrix}

\item{true, }{the true data matrix}

\item{...}{other arguments that can be passed to plot}
}
\value{
a plot object that show the imputation performance
}
\description{
this is a plot function for assessing imputation performance given the imputed data
and the original true data
}
\examples{
data(parkinson)
# introduce 10\% random missing values into the parkinson data
missdata <- SimIm(parkinson, 0.1)

# impute the missing values by LASSO
\donttest{impdata <- impute(missdata, lmFun = "lassoR")

# calculate the normalised RMSE for the imputation
Rmse(impdata$imp, missdata, parkinson, norm = T)

# Plot imputation performance
plotIm(impdata$imp, missdata, parkinson)
}
}
